#!/bin/bash
export datasets="Cora CiteSeer PubMed cs wikics"
export datasets2="Cora CiteSeer PubMed cs wikics physics OGBN-Arxiv"
export missing_rates="0.9 0.99 0.999 0.9999"
export missing_rates_test="0.1"
export lambda_list="1e-5 1e-4 1e-3 1e-2 1e-1 1e+0 1e+1"
export embedders="GNN"
export embedder_lp_list="GCN_LPA Correct_Smooth"
export pseudo_types="4"
export gpu=0

for dataset in $datasets
do
for missing_rate in $missing_rates
do
for pseudo_type in $pseudo_types
do
python main.py --dataset ${dataset} --missing_type uniform --missing_rate ${missing_rate} --pseudo_type ${pseudo_type} --embedder GOODIE_best --n_runs 3 --gpu ${gpu}
python main.py --dataset ${dataset} --missing_type row --missing_rate ${missing_rate} --pseudo_type ${pseudo_type} --embedder GOODIE_best --n_runs 3 --gpu ${gpu}
done
done
done

for dataset in $datasets2
do
for missing_rate in $missing_rates
do
for k in $pseudo_types
do
python main.py --dataset ${dataset} --missing_type uniform --missing_rate ${missing_rate} --pseudo_type -1 --k ${k} --embedder GOODIE_best_wo_k --n_runs 3 --gpu ${gpu}
python main.py --dataset ${dataset} --missing_type row --missing_rate ${missing_rate} --pseudo_type -1 --k ${k} --embedder GOODIE_best_wo_k --n_runs 3 --gpu ${gpu}
done
done
done


for dataset in $datasets2
do
for missing_rate in $missing_rates
do
for lamb in 1e-1 0.0
do
python main.py --dataset ${dataset} --missing_type uniform --missing_rate ${missing_rate} --pseudo_type -1 --lamb ${lamb} --embedder GOODIE_best_wo_lamb --n_runs 3 --gpu ${gpu}
python main.py --dataset ${dataset} --missing_type row --missing_rate ${missing_rate} --pseudo_type -1 --lamb ${lamb} --embedder GOODIE_best_wo_lamb --n_runs 3 --gpu ${gpu}
done
done
done